/*
 * Author: Private Jet Carbon Emissions Calculator
 * Website: https://www.paramountbusinessjets.com/tools/private-jet-carbon-offset-calculator.html
 * Licensed under the Apache 2.0 license
 */

// Aircraft Emissions Data
var aircraftById = { 
  "1":{ 
    "id":1,
    "name":"Citation CJ1+",
    "category":"VLJ",
    "fuel_burn_galph":141
  },
  "2":{ 
    "id":2,
    "name":"Citation Mustang",
    "category":"VLJ",
    "fuel_burn_galph":90
  },
  "3":{ 
    "id":3,
    "name":"Eclipse 500",
    "category":"VLJ",
    "fuel_burn_galph":76
  },
  "4":{ 
    "id":4,
    "name":"Eclipse 550",
    "category":"VLJ",
    "fuel_burn_galph":76
  },
  "5":{ 
    "id":5,
    "name":"Hondajet",
    "category":"VLJ",
    "fuel_burn_galph":120
  },
  "6":{ 
    "id":6,
    "name":"Phenom 100",
    "category":"VLJ",
    "fuel_burn_galph":113
  },
  "7":{ 
    "id":7,
    "name":"Beechjet 400A",
    "category":"Light",
    "fuel_burn_galph":222
  },
  "8":{ 
    "id":8,
    "name":"Citation Bravo",
    "category":"Light",
    "fuel_burn_galph":160
  },
  "9":{ 
    "id":9,
    "name":"Citation CJ2",
    "category":"Light",
    "fuel_burn_galph":141
  },
  "10":{ 
    "id":10,
    "name":"Citation CJ2+",
    "category":"Light",
    "fuel_burn_galph":159
  },
  "11":{ 
    "id":11,
    "name":"Citation CJ3",
    "category":"Light",
    "fuel_burn_galph":172
  },
  "12":{ 
    "id":12,
    "name":"Citation CJ3+",
    "category":"Light",
    "fuel_burn_galph":172
  },
  "13":{ 
    "id":13,
    "name":"Citation CJ4",
    "category":"Light",
    "fuel_burn_galph":209
  },
  "14":{ 
    "id":14,
    "name":"Citation Encore",
    "category":"Light",
    "fuel_burn_galph":205
  },
  "15":{ 
    "id":15,
    "name":"Citation Encore+",
    "category":"Light",
    "fuel_burn_galph":205
  },
  "16":{ 
    "id":16,
    "name":"Citation M2",
    "category":"Light",
    "fuel_burn_galph":134
  },
  "17":{ 
    "id":17,
    "name":"Citation Ultra",
    "category":"Light",
    "fuel_burn_galph":223
  },
  "18":{ 
    "id":18,
    "name":"Citation V",
    "category":"Light",
    "fuel_burn_galph":210
  },
  "19":{ 
    "id":19,
    "name":"Hawker 400XP",
    "category":"Light",
    "fuel_burn_galph":222
  },
  "20":{ 
    "id":20,
    "name":"HondaJet Elite",
    "category":"Light",
    "fuel_burn_galph":0
  },
  "21":{ 
    "id":21,
    "name":"Learjet 31",
    "category":"Light",
    "fuel_burn_galph":202
  },
  "22":{ 
    "id":22,
    "name":"Learjet 40",
    "category":"Light",
    "fuel_burn_galph":207
  },
  "23":{ 
    "id":23,
    "name":"Learjet 40XR",
    "category":"Light",
    "fuel_burn_galph":224
  },
  "24":{ 
    "id":24,
    "name":"Nextant 400XTi",
    "category":"Light",
    "fuel_burn_galph":178
  },
  "25":{ 
    "id":25,
    "name":"Nextant 400XT",
    "category":"Light",
    "fuel_burn_galph":160
  },
  "26":{ 
    "id":26,
    "name":"Pilatus PC-24",
    "category":"Light",
    "fuel_burn_galph":154
  },
  "27":{ 
    "id":27,
    "name":"Premier I",
    "category":"Light",
    "fuel_burn_galph":159
  },
  "28":{ 
    "id":28,
    "name":"Citation Excel",
    "category":"Super Light",
    "fuel_burn_galph":250
  },
  "29":{ 
    "id":29,
    "name":"Citation XLS",
    "category":"Super Light",
    "fuel_burn_galph":239
  },
  "30":{ 
    "id":30,
    "name":"Citation XLS+",
    "category":"Super Light",
    "fuel_burn_galph":239
  },
  "31":{ 
    "id":31,
    "name":"Learjet 45",
    "category":"Super Light",
    "fuel_burn_galph":205
  },
  "32":{ 
    "id":32,
    "name":"Learjet 45XR",
    "category":"Super Light",
    "fuel_burn_galph":227
  },
  "33":{ 
    "id":33,
    "name":"Learjet 70",
    "category":"Super Light",
    "fuel_burn_galph":198
  },
  "34":{ 
    "id":34,
    "name":"Learjet 75",
    "category":"Super Light",
    "fuel_burn_galph":199
  },
  "35":{ 
    "id":35,
    "name":"Phenom 300",
    "category":"Super Light",
    "fuel_burn_galph":183
  },
  "36":{ 
    "id":36,
    "name":"Astra SPX",
    "category":"Midsize",
    "fuel_burn_galph":198
  },
  "37":{ 
    "id":37,
    "name":"Citation Latitude",
    "category":"Midsize",
    "fuel_burn_galph":315
  },
  "38":{ 
    "id":38,
    "name":"Citation VI",
    "category":"Midsize",
    "fuel_burn_galph":276
  },
  "39":{ 
    "id":39,
    "name":"Citation VII",
    "category":"Midsize",
    "fuel_burn_galph":288
  },
  "40":{ 
    "id":40,
    "name":"Gulfstream G100",
    "category":"Midsize",
    "fuel_burn_galph":207
  },
  "41":{ 
    "id":41,
    "name":"Gulfstream G150",
    "category":"Midsize",
    "fuel_burn_galph":228
  },
  "42":{ 
    "id":42,
    "name":"Hawker 800XP",
    "category":"Midsize",
    "fuel_burn_galph":291
  },
  "43":{ 
    "id":43,
    "name":"Hawker 850XP",
    "category":"Midsize",
    "fuel_burn_galph":298
  },
  "44":{ 
    "id":44,
    "name":"Hawker 900XP",
    "category":"Midsize",
    "fuel_burn_galph":265
  },
  "45":{ 
    "id":45,
    "name":"Learjet 60",
    "category":"Midsize",
    "fuel_burn_galph":239
  },
  "46":{ 
    "id":46,
    "name":"Learjet 60XR",
    "category":"Midsize",
    "fuel_burn_galph":222
  },
  "47":{ 
    "id":47,
    "name":"Legacy 450",
    "category":"Midsize",
    "fuel_burn_galph":285
  },
  "48":{ 
    "id":48,
    "name":"Praetor 500",
    "category":"Midsize",
    "fuel_burn_galph":213
  },
  "49":{ 
    "id":49,
    "name":"Westwind II",
    "category":"Midsize",
    "fuel_burn_galph":243
  },
  "50":{ 
    "id":50,
    "name":"Challenger 300",
    "category":"Super Midsize",
    "fuel_burn_galph":295
  },
  "51":{ 
    "id":51,
    "name":"Challenger 350",
    "category":"Super Midsize",
    "fuel_burn_galph":297
  },
  "52":{ 
    "id":52,
    "name":"Citation Sovereign",
    "category":"Super Midsize",
    "fuel_burn_galph":281
  },
  "53":{ 
    "id":53,
    "name":"Citation Sovereign+",
    "category":"Super Midsize",
    "fuel_burn_galph":274
  },
  "54":{ 
    "id":54,
    "name":"Citation X",
    "category":"Super Midsize",
    "fuel_burn_galph":386
  },
  "55":{ 
    "id":55,
    "name":"Citation X+",
    "category":"Super Midsize",
    "fuel_burn_galph":400
  },
  "56":{ 
    "id":56,
    "name":"Falcon 2000",
    "category":"Super Midsize",
    "fuel_burn_galph":287
  },
  "57":{ 
    "id":57,
    "name":"Falcon 2000DX",
    "category":"Super Midsize",
    "fuel_burn_galph":292
  },
  "58":{ 
    "id":58,
    "name":"Falcon 2000EX",
    "category":"Super Midsize",
    "fuel_burn_galph":284
  },
  "59":{ 
    "id":59,
    "name":"Falcon 2000LX",
    "category":"Super Midsize",
    "fuel_burn_galph":321
  },
  "60":{ 
    "id":60,
    "name":"Falcon 2000LXS",
    "category":"Super Midsize",
    "fuel_burn_galph":322
  },
  "61":{ 
    "id":61,
    "name":"Falcon 2000S",
    "category":"Super Midsize",
    "fuel_burn_galph":325
  },
  "62":{ 
    "id":62,
    "name":"Falcon 50EX",
    "category":"Super Midsize",
    "fuel_burn_galph":319
  },
  "63":{ 
    "id":63,
    "name":"Gulfstream G200",
    "category":"Super Midsize",
    "fuel_burn_galph":278
  },
  "64":{ 
    "id":64,
    "name":"Gulfstream G280",
    "category":"Super Midsize",
    "fuel_burn_galph":297
  },
  "65":{ 
    "id":65,
    "name":"Hawker 4000",
    "category":"Super Midsize",
    "fuel_burn_galph":321
  },
  "66":{ 
    "id":66,
    "name":"Legacy 500",
    "category":"Super Midsize",
    "fuel_burn_galph":287
  },
  "67":{ 
    "id":67,
    "name":"Praetor 600",
    "category":"Super Midsize",
    "fuel_burn_galph":236
  },
  "68":{ 
    "id":68,
    "name":"Challenger 601",
    "category":"Large",
    "fuel_burn_galph":365
  },
  "69":{ 
    "id":69,
    "name":"Challenger 604",
    "category":"Large",
    "fuel_burn_galph":358
  },
  "70":{ 
    "id":70,
    "name":"Challenger 605",
    "category":"Large",
    "fuel_burn_galph":329
  },
  "71":{ 
    "id":71,
    "name":"Challenger 650",
    "category":"Large",
    "fuel_burn_galph":329
  },
  "72":{ 
    "id":72,
    "name":"Challenger 850",
    "category":"Large",
    "fuel_burn_galph":346
  },
  "73":{ 
    "id":73,
    "name":"Falcon 900B",
    "category":"Large",
    "fuel_burn_galph":328
  },
  "74":{ 
    "id":74,
    "name":"Falcon 900DX",
    "category":"Large",
    "fuel_burn_galph":314
  },
  "75":{ 
    "id":75,
    "name":"Falcon 900EX",
    "category":"Large",
    "fuel_burn_galph":314
  },
  "76":{ 
    "id":76,
    "name":"Falcon 900LX",
    "category":"Large",
    "fuel_burn_galph":304
  },
  "77":{ 
    "id":77,
    "name":"Global 5000",
    "category":"Large",
    "fuel_burn_galph":506
  },
  "78":{ 
    "id":78,
    "name":"Gulfstream G300",
    "category":"Large",
    "fuel_burn_galph":540
  },
  "79":{ 
    "id":79,
    "name":"Gulfstream G400",
    "category":"Large",
    "fuel_burn_galph":540
  },
  "80":{ 
    "id":80,
    "name":"Gulfstream G450",
    "category":"Large",
    "fuel_burn_galph":517
  },
  "81":{ 
    "id":81,
    "name":"Gulfstream G500",
    "category":"Large",
    "fuel_burn_galph":447
  },
  "82":{ 
    "id":82,
    "name":"Gulfstream GIV-SP",
    "category":"Large",
    "fuel_burn_galph":540
  },
  "83":{ 
    "id":83,
    "name":"Gulfstream GVSP",
    "category":"Large",
    "fuel_burn_galph":503
  },
  "84":{ 
    "id":84,
    "name":"Legacy 600",
    "category":"Large",
    "fuel_burn_galph":363
  },
  "85":{ 
    "id":85,
    "name":"Legacy 650",
    "category":"Large",
    "fuel_burn_galph":381
  },
  "86":{ 
    "id":86,
    "name":"Falcon 7X",
    "category":"Ultra Long Range",
    "fuel_burn_galph":385
  },
  "87":{ 
    "id":87,
    "name":"Global 6000",
    "category":"Ultra Long Range",
    "fuel_burn_galph":512
  },
  "88":{ 
    "id":88,
    "name":"Global 6500",
    "category":"Ultra Long Range",
    "fuel_burn_galph":486
  },
  "89":{ 
    "id":89,
    "name":"Global 7500",
    "category":"Ultra Long Range",
    "fuel_burn_galph":567
  },
  "90":{ 
    "id":90,
    "name":"Global Express",
    "category":"Ultra Long Range",
    "fuel_burn_galph":535
  },
  "91":{ 
    "id":91,
    "name":"Global Express XRS",
    "category":"Ultra Long Range",
    "fuel_burn_galph":532
  },
  "92":{ 
    "id":92,
    "name":"Gulfstream G550",
    "category":"Ultra Long Range",
    "fuel_burn_galph":447
  },
  "93":{ 
    "id":93,
    "name":"Gulfstream G650",
    "category":"Ultra Long Range",
    "fuel_burn_galph":503
  },
  "94":{ 
    "id":94,
    "name":"Gulfstream G650ER",
    "category":"Ultra Long Range",
    "fuel_burn_galph":503
  },
  "95":{ 
    "id":95,
    "name":"Gulfstream GV",
    "category":"Ultra Long Range",
    "fuel_burn_galph":503
  },
  "96":{ 
    "id":96,
    "name":"Airbus ACJ318",
    "category":"VIP Airliner",
    "fuel_burn_galph":690
  },
  "97":{ 
    "id":97,
    "name":"Airbus ACJ319",
    "category":"VIP Airliner",
    "fuel_burn_galph":740
  },
  "98":{ 
    "id":98,
    "name":"Airbus ACJ320",
    "category":"VIP Airliner",
    "fuel_burn_galph":907
  },
  "99":{ 
    "id":99,
    "name":"Boeing 777-200LR VIP",
    "category":"VIP Airliner",
    "fuel_burn_galph":0
  },
  "100":{ 
    "id":100,
    "name":"Boeing Business Jet",
    "category":"VIP Airliner",
    "fuel_burn_galph":758
  },
  "101":{ 
    "id":101,
    "name":"Boeing Business Jet 2",
    "category":"VIP Airliner",
    "fuel_burn_galph":883
  },
  "102":{ 
    "id":102,
    "name":"Boeing Business Jet 3",
    "category":"VIP Airliner",
    "fuel_burn_galph":836
  },
  "103":{ 
    "id":103,
    "name":"Lineage 1000",
    "category":"VIP Airliner",
    "fuel_burn_galph":684
  },
  "104":{ 
    "id":104,
    "name":"Aviator TP600",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":0
  },
  "105":{ 
    "id":105,
    "name":"Beechcraft 1900D",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":0
  },
  "106":{ 
    "id":106,
    "name":"King Air 100",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":102
  },
  "107":{ 
    "id":107,
    "name":"King Air 200",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":113
  },
  "108":{ 
    "id":108,
    "name":"King Air 250",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":138
  },
  "109":{ 
    "id":109,
    "name":"King Air 350",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":136
  },
  "110":{ 
    "id":110,
    "name":"King Air B100",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":104
  },
  "111":{ 
    "id":111,
    "name":"King Air B200",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":113
  },
  "112":{ 
    "id":112,
    "name":"King Air B200GT",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":135
  },
  "113":{ 
    "id":113,
    "name":"King Air C90",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":78
  },
  "114":{ 
    "id":114,
    "name":"King Air C90GTi",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":103
  },
  "115":{ 
    "id":115,
    "name":"Kodiak 100",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":48
  },
  "116":{ 
    "id":116,
    "name":"Kodiak 100 Series II",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":48
  },
  "117":{ 
    "id":117,
    "name":"Piaggio Aero P180 Avanti II",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":136
  },
  "118":{ 
    "id":118,
    "name":"Piaggio P180 Avanti",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":136
  },
  "119":{ 
    "id":119,
    "name":"Pilatus PC-12",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":66
  },
  "120":{ 
    "id":120,
    "name":"Pilatus PC-12 NG",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":76
  },
  "121":{ 
    "id":121,
    "name":"Socata TBM 700",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":62
  },
  "122":{ 
    "id":122,
    "name":"Super King Air F90",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":107
  },
  "123":{ 
    "id":123,
    "name":"Swearingen Fairchild Merlin III",
    "category":"Turboprop Aircraft",
    "fuel_burn_galph":0
  }
};

var aircraftByCategory = { 
  "VLJ": {
    "1":{ 
      "id":1,
      "name":"Citation CJ1+",
      "category":"VLJ",
      "fuel_burn_galph":141
    },
    "2":{ 
      "id":2,
      "name":"Citation Mustang",
      "category":"VLJ",
      "fuel_burn_galph":90
    },
    "3":{ 
      "id":3,
      "name":"Eclipse 500",
      "category":"VLJ",
      "fuel_burn_galph":76
    },
    "4":{ 
      "id":4,
      "name":"Eclipse 550",
      "category":"VLJ",
      "fuel_burn_galph":76
    },
    "5":{ 
      "id":5,
      "name":"Hondajet",
      "category":"VLJ",
      "fuel_burn_galph":120
    },
    "6":{ 
      "id":6,
      "name":"Phenom 100",
      "category":"VLJ",
      "fuel_burn_galph":113
    }
  },
  "Light":{
    "1":{ 
      "id":7,
      "name":"Beechjet 400A",
      "category":"Light",
      "fuel_burn_galph":222
    },
    "2":{ 
      "id":8,
      "name":"Citation Bravo",
      "category":"Light",
      "fuel_burn_galph":160
    },
    "3":{ 
      "id":9,
      "name":"Citation CJ2",
      "category":"Light",
      "fuel_burn_galph":141
    },
    "4":{ 
      "id":10,
      "name":"Citation CJ2+",
      "category":"Light",
      "fuel_burn_galph":159
    },
    "5":{ 
      "id":11,
      "name":"Citation CJ3",
      "category":"Light",
      "fuel_burn_galph":172
    },
    "6":{ 
      "id":12,
      "name":"Citation CJ3+",
      "category":"Light",
      "fuel_burn_galph":172
    },
    "7":{ 
      "id":13,
      "name":"Citation CJ4",
      "category":"Light",
      "fuel_burn_galph":209
    },
    "8":{ 
      "id":14,
      "name":"Citation Encore",
      "category":"Light",
      "fuel_burn_galph":205
    },
    "9":{ 
      "id":15,
      "name":"Citation Encore+",
      "category":"Light",
      "fuel_burn_galph":205
    },
    "10":{ 
      "id":16,
      "name":"Citation M2",
      "category":"Light",
      "fuel_burn_galph":134
    },
    "11":{ 
      "id":17,
      "name":"Citation Ultra",
      "category":"Light",
      "fuel_burn_galph":223
    },
    "12":{ 
      "id":18,
      "name":"Citation V",
      "category":"Light",
      "fuel_burn_galph":210
    },
    "13":{ 
      "id":19,
      "name":"Hawker 400XP",
      "category":"Light",
      "fuel_burn_galph":222
    },
    "14":{ 
      "id":20,
      "name":"HondaJet Elite",
      "category":"Light",
      "fuel_burn_galph":0
    },
    "15":{ 
      "id":21,
      "name":"Learjet 31",
      "category":"Light",
      "fuel_burn_galph":202
    },
    "16":{ 
      "id":22,
      "name":"Learjet 40",
      "category":"Light",
      "fuel_burn_galph":207
    },
    "17":{ 
      "id":23,
      "name":"Learjet 40XR",
      "category":"Light",
      "fuel_burn_galph":224
    },
    "18":{ 
      "id":24,
      "name":"Nextant 400XTi",
      "category":"Light",
      "fuel_burn_galph":178
    },
    "19":{ 
      "id":25,
      "name":"Nextant 400XT",
      "category":"Light",
      "fuel_burn_galph":160
    },
    "20":{ 
      "id":26,
      "name":"Pilatus PC-24",
      "category":"Light",
      "fuel_burn_galph":154
    },
    "21":{ 
      "id":27,
      "name":"Premier I",
      "category":"Light",
      "fuel_burn_galph":159
    }
  },
  "Super Light": {
    "1":{ 
      "id":28,
      "name":"Citation Excel",
      "category":"Super Light",
      "fuel_burn_galph":250
    },
    "2":{ 
      "id":29,
      "name":"Citation XLS",
      "category":"Super Light",
      "fuel_burn_galph":239
    },
    "3":{ 
      "id":30,
      "name":"Citation XLS+",
      "category":"Super Light",
      "fuel_burn_galph":239
    },
    "4":{ 
      "id":31,
      "name":"Learjet 45",
      "category":"Super Light",
      "fuel_burn_galph":205
    },
    "5":{ 
      "id":32,
      "name":"Learjet 45XR",
      "category":"Super Light",
      "fuel_burn_galph":227
    },
    "6":{ 
      "id":33,
      "name":"Learjet 70",
      "category":"Super Light",
      "fuel_burn_galph":198
    },
    "7":{ 
      "id":34,
      "name":"Learjet 75",
      "category":"Super Light",
      "fuel_burn_galph":199
    },
    "8":{ 
      "id":35,
      "name":"Phenom 300",
      "category":"Super Light",
      "fuel_burn_galph":183
    }
  },
  "Midsize": {
    "1":{ 
      "id":36,
      "name":"Astra SPX",
      "category":"Midsize",
      "fuel_burn_galph":198
    },
    "2":{ 
      "id":37,
      "name":"Citation Latitude",
      "category":"Midsize",
      "fuel_burn_galph":315
    },
    "3":{ 
      "id":38,
      "name":"Citation VI",
      "category":"Midsize",
      "fuel_burn_galph":276
    },
    "4":{ 
      "id":39,
      "name":"Citation VII",
      "category":"Midsize",
      "fuel_burn_galph":288
    },
    "5":{ 
      "id":40,
      "name":"Gulfstream G100",
      "category":"Midsize",
      "fuel_burn_galph":207
    },
    "6":{ 
      "id":41,
      "name":"Gulfstream G150",
      "category":"Midsize",
      "fuel_burn_galph":228
    },
    "7":{ 
      "id":42,
      "name":"Hawker 800XP",
      "category":"Midsize",
      "fuel_burn_galph":291
    },
    "8":{ 
      "id":43,
      "name":"Hawker 850XP",
      "category":"Midsize",
      "fuel_burn_galph":298
    },
    "9":{ 
      "id":44,
      "name":"Hawker 900XP",
      "category":"Midsize",
      "fuel_burn_galph":265
    },
    "10":{ 
      "id":45,
      "name":"Learjet 60",
      "category":"Midsize",
      "fuel_burn_galph":239
    },
    "11":{ 
      "id":46,
      "name":"Learjet 60XR",
      "category":"Midsize",
      "fuel_burn_galph":222
    },
    "12":{ 
      "id":47,
      "name":"Legacy 450",
      "category":"Midsize",
      "fuel_burn_galph":285
    },
    "13":{ 
      "id":48,
      "name":"Praetor 500",
      "category":"Midsize",
      "fuel_burn_galph":213
    },
    "14":{ 
      "id":49,
      "name":"Westwind II",
      "category":"Midsize",
      "fuel_burn_galph":243
    },
    "1":{ 
      "id":50,
      "name":"Challenger 300",
      "category":"Super Midsize",
      "fuel_burn_galph":295
    },
    "2":{ 
      "id":51,
      "name":"Challenger 350",
      "category":"Super Midsize",
      "fuel_burn_galph":297
    },
    "3":{ 
      "id":52,
      "name":"Citation Sovereign",
      "category":"Super Midsize",
      "fuel_burn_galph":281
    },
    "4":{ 
      "id":53,
      "name":"Citation Sovereign+",
      "category":"Super Midsize",
      "fuel_burn_galph":274
    },
    "5":{ 
      "id":54,
      "name":"Citation X",
      "category":"Super Midsize",
      "fuel_burn_galph":386
    },
    "6":{ 
      "id":55,
      "name":"Citation X+",
      "category":"Super Midsize",
      "fuel_burn_galph":400
    },
    "7":{ 
      "id":56,
      "name":"Falcon 2000",
      "category":"Super Midsize",
      "fuel_burn_galph":287
    },
    "8":{ 
      "id":57,
      "name":"Falcon 2000DX",
      "category":"Super Midsize",
      "fuel_burn_galph":292
    },
    "9":{ 
      "id":58,
      "name":"Falcon 2000EX",
      "category":"Super Midsize",
      "fuel_burn_galph":284
    },
    "10":{ 
      "id":59,
      "name":"Falcon 2000LX",
      "category":"Super Midsize",
      "fuel_burn_galph":321
    },
    "11":{ 
      "id":60,
      "name":"Falcon 2000LXS",
      "category":"Super Midsize",
      "fuel_burn_galph":322
    },
    "12":{ 
      "id":61,
      "name":"Falcon 2000S",
      "category":"Super Midsize",
      "fuel_burn_galph":325
    },
    "13":{ 
      "id":62,
      "name":"Falcon 50EX",
      "category":"Super Midsize",
      "fuel_burn_galph":319
    },
    "14":{ 
      "id":63,
      "name":"Gulfstream G200",
      "category":"Super Midsize",
      "fuel_burn_galph":278
    },
    "15":{ 
      "id":64,
      "name":"Gulfstream G280",
      "category":"Super Midsize",
      "fuel_burn_galph":297
    },
    "16":{ 
      "id":65,
      "name":"Hawker 4000",
      "category":"Super Midsize",
      "fuel_burn_galph":321
    },
    "17":{ 
      "id":66,
      "name":"Legacy 500",
      "category":"Super Midsize",
      "fuel_burn_galph":287
    },
    "18":{ 
      "id":67,
      "name":"Praetor 600",
      "category":"Super Midsize",
      "fuel_burn_galph":236
    }
  }, 
  "Large": {
    "1":{ 
      "id":68,
      "name":"Challenger 601",
      "category":"Large",
      "fuel_burn_galph":365
    },
    "2":{ 
      "id":69,
      "name":"Challenger 604",
      "category":"Large",
      "fuel_burn_galph":358
    },
    "3":{ 
      "id":70,
      "name":"Challenger 605",
      "category":"Large",
      "fuel_burn_galph":329
    },
    "4":{ 
      "id":71,
      "name":"Challenger 650",
      "category":"Large",
      "fuel_burn_galph":329
    },
    "5":{ 
      "id":72,
      "name":"Challenger 850",
      "category":"Large",
      "fuel_burn_galph":346
    },
    "6":{ 
      "id":73,
      "name":"Falcon 900B",
      "category":"Large",
      "fuel_burn_galph":328
    },
    "7":{ 
      "id":74,
      "name":"Falcon 900DX",
      "category":"Large",
      "fuel_burn_galph":314
    },
    "8":{ 
      "id":75,
      "name":"Falcon 900EX",
      "category":"Large",
      "fuel_burn_galph":314
    },
    "9":{ 
      "id":76,
      "name":"Falcon 900LX",
      "category":"Large",
      "fuel_burn_galph":304
    },
    "10":{ 
      "id":77,
      "name":"Global 5000",
      "category":"Large",
      "fuel_burn_galph":506
    },
    "11":{ 
      "id":78,
      "name":"Gulfstream G300",
      "category":"Large",
      "fuel_burn_galph":540
    },
    "12":{ 
      "id":79,
      "name":"Gulfstream G400",
      "category":"Large",
      "fuel_burn_galph":540
    },
    "13":{ 
      "id":80,
      "name":"Gulfstream G450",
      "category":"Large",
      "fuel_burn_galph":517
    },
    "14":{ 
      "id":81,
      "name":"Gulfstream G500",
      "category":"Large",
      "fuel_burn_galph":447
    },
    "15":{ 
      "id":82,
      "name":"Gulfstream GIV-SP",
      "category":"Large",
      "fuel_burn_galph":540
    },
    "16":{ 
      "id":83,
      "name":"Gulfstream GVSP",
      "category":"Large",
      "fuel_burn_galph":503
    },
    "17":{ 
      "id":84,
      "name":"Legacy 600",
      "category":"Large",
      "fuel_burn_galph":363
    },
    "18":{ 
      "id":85,
      "name":"Legacy 650",
      "category":"Large",
      "fuel_burn_galph":381
    }
  },
  "Ultra Long Range": {
    "1":{ 
      "id":86,
      "name":"Falcon 7X",
      "category":"Ultra Long Range",
      "fuel_burn_galph":385
    },
    "2":{ 
      "id":87,
      "name":"Global 6000",
      "category":"Ultra Long Range",
      "fuel_burn_galph":512
    },
    "3":{ 
      "id":88,
      "name":"Global 6500",
      "category":"Ultra Long Range",
      "fuel_burn_galph":486
    },
    "4":{ 
      "id":89,
      "name":"Global 7500",
      "category":"Ultra Long Range",
      "fuel_burn_galph":567
    },
    "5":{ 
      "id":90,
      "name":"Global Express",
      "category":"Ultra Long Range",
      "fuel_burn_galph":535
    },
    "6":{ 
      "id":91,
      "name":"Global Express XRS",
      "category":"Ultra Long Range",
      "fuel_burn_galph":532
    },
    "7":{ 
      "id":92,
      "name":"Gulfstream G550",
      "category":"Ultra Long Range",
      "fuel_burn_galph":447
    },
    "8":{ 
      "id":93,
      "name":"Gulfstream G650",
      "category":"Ultra Long Range",
      "fuel_burn_galph":503
    },
    "9":{ 
      "id":94,
      "name":"Gulfstream G650ER",
      "category":"Ultra Long Range",
      "fuel_burn_galph":503
    },
    "10":{ 
      "id":95,
      "name":"Gulfstream GV",
      "category":"Ultra Long Range",
      "fuel_burn_galph":503
    }
  }, 
  "VIP Airliner": {
    "1":{ 
      "id":96,
      "name":"Airbus ACJ318",
      "category":"VIP Airliner",
      "fuel_burn_galph":690
    },
    "2":{ 
      "id":97,
      "name":"Airbus ACJ319",
      "category":"VIP Airliner",
      "fuel_burn_galph":740
    },
    "3":{ 
      "id":98,
      "name":"Airbus ACJ320",
      "category":"VIP Airliner",
      "fuel_burn_galph":907
    },
    "4":{ 
      "id":99,
      "name":"Boeing 777-200LR VIP",
      "category":"VIP Airliner",
      "fuel_burn_galph":0
    },
    "5":{ 
      "id":100,
      "name":"Boeing Business Jet",
      "category":"VIP Airliner",
      "fuel_burn_galph":758
    },
    "6":{ 
      "id":101,
      "name":"Boeing Business Jet 2",
      "category":"VIP Airliner",
      "fuel_burn_galph":883
    },
    "7":{ 
      "id":102,
      "name":"Boeing Business Jet 3",
      "category":"VIP Airliner",
      "fuel_burn_galph":836
    },
    "8":{ 
      "id":103,
      "name":"Lineage 1000",
      "category":"VIP Airliner",
      "fuel_burn_galph":684
    }
  }, 
  "Turboprop Aircraft": {
    "1":{ 
      "id":104,
      "name":"Aviator TP600",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":0
    },
    "2":{ 
      "id":105,
      "name":"Beechcraft 1900D",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":0
    },
    "3":{ 
      "id":106,
      "name":"King Air 100",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":102
    },
    "4":{ 
      "id":107,
      "name":"King Air 200",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":113
    },
    "5":{ 
      "id":108,
      "name":"King Air 250",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":138
    },
    "6":{ 
      "id":109,
      "name":"King Air 350",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":136
    },
    "7":{ 
      "id":110,
      "name":"King Air B100",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":104
    },
    "8":{ 
      "id":111,
      "name":"King Air B200",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":113
    },
    "9":{ 
      "id":112,
      "name":"King Air B200GT",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":135
    },
    "10":{ 
      "id":113,
      "name":"King Air C90",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":78
    },
    "11":{ 
      "id":114,
      "name":"King Air C90GTi",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":103
    },
    "12":{ 
      "id":115,
      "name":"Kodiak 100",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":48
    },
    "13":{ 
      "id":116,
      "name":"Kodiak 100 Series II",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":48
    },
    "14":{ 
      "id":117,
      "name":"Piaggio Aero P180 Avanti II",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":136
    },
    "15":{ 
      "id":118,
      "name":"Piaggio P180 Avanti",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":136
    },
    "16":{ 
      "id":119,
      "name":"Pilatus PC-12",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":66
    },
    "17":{ 
      "id":120,
      "name":"Pilatus PC-12 NG",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":76
    },
    "18":{ 
      "id":121,
      "name":"Socata TBM 700",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":62
    },
    "19":{ 
      "id":122,
      "name":"Super King Air F90",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":107
    },
    "20":{ 
      "id":123,
      "name":"Swearingen Fairchild Merlin III",
      "category":"Turboprop Aircraft",
      "fuel_burn_galph":0
    }
  }
}

var aircraftCategories = ["VLJ", "Light", "Super Light", "Midsize", "Large", "Ultra Long Range", "VIP Airliner", "Turboprop Aircraft"];


var carbonOffsetProviders = {
  "1": {
    "name": "Terrapass",
    "url": "https://www.terrapass.com/product/productindividuals-families"
  },
  "2": {
    "name": "Green Mountain Energy",
    "url": "https://www.greenmountainenergy.com/home-energy-solutions/carbon-offsets/"
  },
  "3": {
    "name": "Stand for Trees",
    "url": "https://standfortrees.org/en/fooftprint"
  },
  "4": {
    "name": "Carbon Fund",
    "url": "https://www.carbonfund.org/product/general-donation/"
  },
  "5": {
    "name": "Bio Carbon Partners",
    "url": "https://biocarbonpartners.com/buy-offsets/"
  },
  "6": {
    "name": "Carbon Footprint",
    "url": "https://www.carbonfootprint.com/carbonoffset.html"
  },
  "7": {
    "name": "Carbon Offsets To Alleviate Poverty",
    "url": "https://cotap.org/offset-co2-by-the-tonne/"
  },
  "8": {
    "name": "Climate Care",
    "url": "https://climatecare.org/calculator/"
  }
}


document.addEventListener('DOMContentLoaded', function() {
  // create options for aircraft type select
  var aircraftList = '<option value="">Select an Aircraft Type</option>';
  for(let i = 0; i < aircraftCategories.length; i++){
    numAircraft = Object.keys(aircraftByCategory[aircraftCategories[i]]).length;
    aircraftList += '<optgroup label="' + aircraftCategories[i] + '">';
    for(let a = 1; a <= numAircraft; a++){
      aircraftList += '<option value="' + aircraftByCategory[aircraftCategories[i]][a].id + '">' + aircraftByCategory[aircraftCategories[i]][a].name + '</option>';
    }
    aircraftList += '</optgroup>';
  }
  var aircraftSelect = document.getElementById("aircraft-type");
  aircraftSelect.innerHTML = aircraftList;

  // Calculate Emissions on form submit
  var form = document.getElementById("carbon-emissions-calculator-form");
  form.addEventListener("submit", function(evt) {
    evt.preventDefault();
    // Clear all the error fields
    var errorElements = document.getElementsByClassName('error');
    for (var i = 0; i < errorElements.length; i++) {
      errorElements[i].innerHTML = '';
    }
    // Calculate the emissions
    calculateEmissions();
  });
});

function calculateEmissions() {
  var aircraftId = document.getElementById("aircraft-type").value;
  var flightTime = document.getElementById("flight-time").value;
  var jetFuelCO2Coeff = 21.1; // Amount of CO2 in lbs created from burning 1 gallon of Jet Fuel. Source: https://www.eia.gov/environment/emissions/co2_vol_mass.php

  // Check for errors
  var error = false;
  if(isNaN(aircraftId) || aircraftId <= 0){
    document.getElementById("aircraft-type-error").innerHTML = 'Please select an aircraft';
    error = true;
  }
  if(isNaN(flightTime) || flightTime <= 0){
    document.getElementById("flight-time-error").innerHTML = 'Please enter a valid number';
    error = true;
  }

  // If there are no errors, calculate the emissions
  if(!error){
    var fuelBurn = aircraftById[aircraftId].fuel_burn_galph;
    // For aircraft that we don't have a fuel burn value
    if(fuelBurn == 0){
      // Get average fuel burn for the category
      fuelBurn = getAverageFuelBurn(aircraftById[aircraftId].category);
      if(fuelBurn == -1){
        // Error in getting the average
        document.getElementById("results").innerHTML = '<span class="error">This aircraft does not have a fuel burn value specified and we had trouble calculating the average for the aircraft category as well.</span>';
        return;
      }
    }
    // Calculate the emissions
    var emissionsInLbs = Math.ceil(fuelBurn * flightTime * jetFuelCO2Coeff);
    var emissionsInMT = Math.ceil(emissionsInLbs / 2204.60);
    
    // Get a list of offset providers
    var carbonOffsetOptions = '<ul>';
    var numOffsetProviders = Object.keys(carbonOffsetProviders).length;
    for(let i = 1; i <= numOffsetProviders; i++){
      carbonOffsetOptions += '<li><a href="' + carbonOffsetProviders[i].url + '" target="_blank" rel="noopener noreferrer">' + carbonOffsetProviders[i].name + '</a></li>';
    }
    carbonOffsetOptions += '</ul>';
    
    // Print the results
    document.getElementById("results").innerHTML = '<h2>Carbon Emissions: ' + emissionsInLbs.toLocaleString() + ' lbs / ' + emissionsInMT.toLocaleString() + ' mT</h2><p><b>KEY</b>: <b>lbs</b> - Pounds, <b>mT</b> - Metric Tonnes</p><p>You can use any of the following providers to buy offsets for this trip:</p>' + carbonOffsetOptions;
  }
}

function getAverageFuelBurn(category){
  // Show an error if the category is not specified
  if(category == 'undefined'){
    document.getElementById("results").innerHTML = '<span class="error">You have not specified an aircraft category to get the average fuel burn</span>';
  }
  // Calculate the average fuel burn for the category
  numAircraft = Object.keys(aircraftByCategory[category]).length;
  numAircraftWithFuelBurn = 0;
  totalFuelBurn = 0;
  // Go through all the aircraft in the category and get the totals
  for(let a = 1; a <= numAircraft; a++){
    var fuelBurn = aircraftByCategory[category][a].fuel_burn_galph;
    // Only count aircraft which have a fuel burn value > 0
    if(fuelBurn > 0){
      numAircraftWithFuelBurn += 1;
      totalFuelBurn += fuelBurn;
    }
  }
  if(numAircraftWithFuelBurn > 0){
    // Return the average
    return totalFuelBurn/numAircraftWithFuelBurn;
  } else {
    // Return an error
    return -1;
  }
}
