# Private Jet Carbon Emissions Calculator
Welcome! 

This is an open source carbon emissions calculator for private jet flights created by Paramount Business Jets. Our goal is for the aviation industry to use this tool on their websites so that their clients can check how much carbon emissions are being generated from their flights and help the environment by contributing the amount for their carbon offsets through various providers. 

View a [demo of the calculator](https://www.paramountbusinessjets.com/tools/private-jet-carbon-offset-calculator.html) here.

## How to use this calculator
Download the files or clone this repo, and load index.html in your browser. That's it :)

The calculator has been created with HTML and Javascript, with minimal CSS for the styling. This is mainly as a proof of concept and to make it as easy as possible to modify it and brand it according to your needs.

Feel free to integrate it and adapt the code with your preferred backend language to create your unique version of the calculator.

## Data for the calculator and other notes
The Javascript file contains two JSON objects (```aircraftById``` and ```aircraftByCategory```) for the aircraft data, including the fuel burn for each type of aircraft. These numbers have been sourced through research.

5 out of the 123 aircraft in the list do not have fuel burn numbers. For those aircraft, the calculator estimates the fuel burn by taking the average of all the other aircraft in the same category. 

The formula used to calculate the emissions in pounds (lbs) is: 

**Emissions (lbs) = Flight Time (hours) x Fuel Burn (gal/hr) x 21.1\***

The emissions are converted to Metric Tonnes (mT) as follows:

**Emissions (mT) = Emissions (lbs) / 2204.60**

\*21.1 is the Carbon Dioxide Emissions Coefficient for Jet Fuel (lbs of CO2 emitted per gallon of fuel burnt), as specified by the [US Energy Information Administration](https://www.eia.gov/environment/emissions/co2_vol_mass.php).

## Sources for buying carbon offsets
We’ve listed 8 different sources for buying carbon offsets in the results. 

These sources are specified in the ```carbonOffsetProviders``` JSON object in the Javascript file. You can edit these sources as per your preferences. 

Happy coding! Let's take care of our environment!